/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.events.ImpactorEventBus;
import net.impactdev.impactor.api.platform.Platform;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.plugin.ImpactorPlugin;
import net.impactdev.impactor.core.modules.ModuleInitializer;
import net.impactdev.impactor.core.plugin.ImpactorBootstrapper;
import net.impactdev.impactor.fabric.commands.FabricCommandModule;
import net.impactdev.impactor.fabric.integrations.PlaceholderAPIIntegration;
import net.impactdev.impactor.fabric.mixins.bridge.FabricMixinBridge;
import net.impactdev.impactor.fabric.platform.FabricPlatformModule;
import net.impactdev.impactor.fabric.scheduler.FabricSchedulerModule;
import net.impactdev.impactor.fabric.ui.FabricUIModule;
import net.impactdev.impactor.minecraft.mixins.MixinBridge;
import net.impactdev.impactor.minecraft.platform.sources.ImpactorPlatformPlayer;
import net.impactdev.impactor.minecraft.plugin.GameImpactorPlugin;

public final class FabricImpactorPlugin
extends GameImpactorPlugin
implements ImpactorPlugin {
    public FabricImpactorPlugin(ImpactorBootstrapper bootstrapper) {
        super(bootstrapper);
    }

    @Override
    public void construct() {
        super.construct();
        Impactor.instance().factories().register(MixinBridge.class, new FabricMixinBridge());
        Platform platform = Impactor.instance().platform();
        if (platform.info().plugin("placeholder-api").isPresent()) {
            PlaceholderAPIIntegration papi = new PlaceholderAPIIntegration();
            papi.subscribe(this.logger(), ImpactorEventBus.bus());
            ServerLifecycleEvents.SERVER_STARTING.register(ignore -> papi.registerToPapi());
        }
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            PlatformPlayer player = PlatformPlayer.getOrCreate(handler.field_14140.method_5667());
            player.withDynamic(ImpactorPlatformPlayer.PLAYER_FALLBACK, () -> handler.field_14140);
            Impactor.instance().events().post(() -> player);
        });
    }

    @Override
    protected ModuleInitializer registerModules() {
        return super.registerModules().with(FabricSchedulerModule.class).with(FabricUIModule.class).with(FabricPlatformModule.class).with(FabricCommandModule.class);
    }
}

